<?php
require_once '../includes/config.php';
require_once '../includes/auth.php';

$auth = getAuth();

// Check if request is POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: ../public/login.php');
    exit();
}

// Verify CSRF token
if (!$auth->verifyCSRFToken($_POST['csrf_token'] ?? '')) {
    $_SESSION['error_message'] = 'Invalid request. Please try again.';
    header('Location: ../public/login.php');
    exit();
}

// Sanitize and validate input
$email = $auth->sanitizeInput($_POST['email'] ?? '');
$password = $_POST['password'] ?? '';

// Validation
$errors = [];

if (empty($email) || !$auth->validateEmail($email)) {
    $errors[] = 'Valid email address is required';
}

if (empty($password)) {
    $errors[] = 'Password is required';
}

// If validation fails, redirect back with errors
if (!empty($errors)) {
    $_SESSION['error_message'] = implode('<br>', $errors);
    header('Location: ../public/login.php');
    exit();
}

// Attempt login
$result = $auth->login($email, $password);

if ($result['success']) {
    $_SESSION['success_message'] = 'Welcome back!';
    header('Location: ../public/dashboard.php');
} else {
    $_SESSION['error_message'] = $result['message'];
    header('Location: ../public/login.php');
}
exit();
?>
