<?php
require_once '../includes/config.php';
require_once '../includes/auth.php';

$auth = getAuth();
$page_title = 'About Us';
?>

<?php include '../includes/header.php'; ?>

<!-- Hero Section -->
<section class="py-5 bg-light">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <h1 class="display-4 fw-bold mb-4">About SwiftBill NG</h1>
                <p class="lead mb-4">
                    We're on a mission to help Nigerian freelancers and SMEs streamline their billing 
                    and payment collection with professional invoicing solutions.
                </p>
                <p class="text-muted">
                    Founded in 2024, SwiftBill NG was born out of the frustration of chasing payments 
                    and managing invoices manually. We believe every business deserves to get paid 
                    faster and focus on what they do best.
                </p>
            </div>
            <div class="col-lg-6 text-center">
                <div class="about-image">
                    <div class="bg-primary bg-opacity-10 rounded-circle p-5 d-inline-block">
                        <i class="bi bi-people-fill text-primary" style="font-size: 5rem;"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Mission Section -->
<section class="py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center">
                <h2 class="display-5 fw-bold mb-4">Our Mission</h2>
                <p class="lead text-muted mb-5">
                    To empower Nigerian businesses with simple, secure, and efficient invoicing tools 
                    that help them get paid faster and grow their revenue.
                </p>
            </div>
        </div>
        
        <div class="row g-4">
            <div class="col-md-4 text-center">
                <div class="value-item">
                    <div class="bg-primary bg-opacity-10 rounded-circle p-3 mb-3 mx-auto" style="width: 80px; height: 80px;">
                        <i class="bi bi-shield-check text-primary" style="font-size: 2rem;"></i>
                    </div>
                    <h4 class="fw-bold mb-3">Security First</h4>
                    <p class="text-muted">
                        Your data and payments are protected with bank-level security and encryption.
                    </p>
                </div>
            </div>
            
            <div class="col-md-4 text-center">
                <div class="value-item">
                    <div class="bg-success bg-opacity-10 rounded-circle p-3 mb-3 mx-auto" style="width: 80px; height: 80px;">
                        <i class="bi bi-lightning-charge text-success" style="font-size: 2rem;"></i>
                    </div>
                    <h4 class="fw-bold mb-3">Speed & Efficiency</h4>
                    <p class="text-muted">
                        Create and send professional invoices in minutes, not hours.
                    </p>
                </div>
            </div>
            
            <div class="col-md-4 text-center">
                <div class="value-item">
                    <div class="bg-warning bg-opacity-10 rounded-circle p-3 mb-3 mx-auto" style="width: 80px; height: 80px;">
                        <i class="bi bi-heart text-warning" style="font-size: 2rem;"></i>
                    </div>
                    <h4 class="fw-bold mb-3">Made for Nigeria</h4>
                    <p class="text-muted">
                        Built specifically for Nigerian businesses with local payment methods and support.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- How It Works Section -->
<section class="py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center mb-5">
                <h2 class="display-5 fw-bold mb-3">How SwiftBill NG Works</h2>
                <p class="lead text-muted">Simple steps to get paid faster</p>
            </div>
        </div>
        
        <div class="row g-4 align-items-center">
            <div class="col-lg-6">
                <div class="steps-list">
                    <div class="step-item d-flex mb-4">
                        <div class="step-number bg-primary text-white rounded-circle me-3 d-flex align-items-center justify-content-center" style="width: 50px; height: 50px; min-width: 50px;">
                            <span class="fw-bold">1</span>
                        </div>
                        <div>
                            <h5 class="fw-bold mb-2">Create Your Invoice</h5>
                            <p class="text-muted mb-0">
                                Add client details, services, and amounts. Our system generates professional invoices automatically.
                            </p>
                        </div>
                    </div>
                    
                    <div class="step-item d-flex mb-4">
                        <div class="step-number bg-primary text-white rounded-circle me-3 d-flex align-items-center justify-content-center" style="width: 50px; height: 50px; min-width: 50px;">
                            <span class="fw-bold">2</span>
                        </div>
                        <div>
                            <h5 class="fw-bold mb-2">Share Payment Link</h5>
                            <p class="text-muted mb-0">
                                Send via email or share the secure payment link. Clients can pay with cards, bank transfers, or mobile money.
                            </p>
                        </div>
                    </div>
                    
                    <div class="step-item d-flex mb-4">
                        <div class="step-number bg-primary text-white rounded-circle me-3 d-flex align-items-center justify-content-center" style="width: 50px; height: 50px; min-width: 50px;">
                            <span class="fw-bold">3</span>
                        </div>
                        <div>
                            <h5 class="fw-bold mb-2">Get Paid Instantly</h5>
                            <p class="text-muted mb-0">
                                Receive notifications when payments are made. Money goes directly to your account with automatic receipts.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-6 text-center">
                <div class="workflow-visual">
                    <div class="bg-primary bg-opacity-10 rounded p-5">
                        <i class="bi bi-arrow-repeat text-primary" style="font-size: 5rem;"></i>
                        <h4 class="fw-bold mt-3 text-primary">Automated Workflow</h4>
                        <p class="text-muted">From invoice creation to payment confirmation</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Features Section -->
<section class="py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center mb-5">
                <h2 class="display-5 fw-bold mb-3">Why Choose SwiftBill NG?</h2>
                <p class="lead text-muted">Built for Nigerian businesses, by Nigerians</p>
            </div>
        </div>
        
        <div class="row g-4">
            <div class="col-md-6 col-lg-3">
                <div class="feature-card text-center p-4">
                    <i class="bi bi-currency-exchange text-primary mb-3" style="font-size: 2.5rem;"></i>
                    <h5 class="fw-bold mb-2">Local Payments</h5>
                    <p class="text-muted small">Support for Naira, bank transfers, and mobile money</p>
                </div>
            </div>
            
            <div class="col-md-6 col-lg-3">
                <div class="feature-card text-center p-4">
                    <i class="bi bi-phone text-primary mb-3" style="font-size: 2.5rem;"></i>
                    <h5 class="fw-bold mb-2">Mobile Friendly</h5>
                    <p class="text-muted small">Works perfectly on all devices and screen sizes</p>
                </div>
            </div>
            
            <div class="col-md-6 col-lg-3">
                <div class="feature-card text-center p-4">
                    <i class="bi bi-clock text-primary mb-3" style="font-size: 2.5rem;"></i>
                    <h5 class="fw-bold mb-2">24/7 Support</h5>
                    <p class="text-muted small">Get help whenever you need it from our local team</p>
                </div>
            </div>
            
            <div class="col-md-6 col-lg-3">
                <div class="feature-card text-center p-4">
                    <i class="bi bi-graph-up text-primary mb-3" style="font-size: 2.5rem;"></i>
                    <h5 class="fw-bold mb-2">Business Growth</h5>
                    <p class="text-muted small">Analytics and insights to help grow your business</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-5 bg-primary text-white">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8">
                <h2 class="display-5 fw-bold mb-3">Ready to Transform Your Business?</h2>
                <p class="lead mb-0">
                    Join thousands of Nigerian businesses already using SwiftBill NG to get paid faster.
                </p>
            </div>
            <div class="col-lg-4 text-lg-end mt-4 mt-lg-0">
                <a href="register.php" class="btn btn-light btn-lg px-4">
                    <i class="bi bi-rocket-takeoff me-2"></i>Get Started Today
                </a>
            </div>
        </div>
    </div>
</section>

<?php include '../includes/footer.php'; ?>
