<?php
require_once '../includes/config.php';
require_once '../includes/auth.php';

$auth = getAuth();
$page_title = 'Home';
?>

<?php include '../includes/header.php'; ?>

<!-- Hero Section -->
<section class="hero-section bg-primary text-white py-5">
    <div class="container">
        <div class="row align-items-center min-vh-75">
            <div class="col-lg-6">
                <h1 class="display-4 fw-bold mb-4">
                    Get Paid Faster, Anywhere in Nigeria
                </h1>
                <p class="lead mb-4">
                    SwiftBill NG helps Nigerian freelancers and SMEs create professional invoices, 
                    send payment links, and get paid faster with automated reminders.
                </p>
                <div class="d-flex flex-column flex-sm-row gap-3">
                    <a href="register.php" class="btn btn-light btn-lg px-4">
                        <i class="bi bi-rocket-takeoff me-2"></i>Get Started Free
                    </a>
                    <a href="#features" class="btn btn-outline-light btn-lg px-4">
                        <i class="bi bi-play-circle me-2"></i>Learn More
                    </a>
                </div>
                <div class="mt-4">
                    <small class="text-light opacity-75">
                        <i class="bi bi-check-circle me-1"></i>No setup fees
                        <i class="bi bi-check-circle me-1 ms-3"></i>Secure payments
                        <i class="bi bi-check-circle me-1 ms-3"></i>24/7 support
                    </small>
                </div>
            </div>
            <div class="col-lg-6 text-center">
                <div class="hero-image mt-5 mt-lg-0">
                    <div class="card shadow-lg border-0" style="transform: rotate(-5deg);">
                        <div class="card-body p-4">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h5 class="text-primary mb-0">Invoice #SBN001</h5>
                                <span class="badge bg-success">PAID</span>
                            </div>
                            <div class="row text-start">
                                <div class="col-6">
                                    <small class="text-muted">From:</small>
                                    <p class="mb-1 fw-bold">John Doe</p>
                                </div>
                                <div class="col-6">
                                    <small class="text-muted">To:</small>
                                    <p class="mb-1 fw-bold">ABC Company</p>
                                </div>
                            </div>
                            <hr>
                            <div class="d-flex justify-content-between">
                                <span>Web Development</span>
                                <span class="fw-bold">₦150,000</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Features Section -->
<section id="features" class="py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center mb-5">
                <h2 class="display-5 fw-bold mb-3">Everything You Need to Get Paid</h2>
                <p class="lead text-muted">
                    Streamline your billing process with our comprehensive invoicing solution
                </p>
            </div>
        </div>
        
        <div class="row g-4">
            <div class="col-md-4">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body text-center p-4">
                        <div class="feature-icon bg-primary bg-opacity-10 rounded-circle p-3 mb-3 mx-auto" style="width: 80px; height: 80px;">
                            <i class="bi bi-receipt text-primary" style="font-size: 2rem;"></i>
                        </div>
                        <h4 class="fw-bold mb-3">Simple Invoicing</h4>
                        <p class="text-muted">
                            Create professional invoices in minutes with our intuitive interface. 
                            Add your logo, customize templates, and send instantly.
                        </p>
                    </div>
                </div>
            </div>
            
            <div class="col-md-4">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body text-center p-4">
                        <div class="feature-icon bg-success bg-opacity-10 rounded-circle p-3 mb-3 mx-auto" style="width: 80px; height: 80px;">
                            <i class="bi bi-credit-card text-success" style="font-size: 2rem;"></i>
                        </div>
                        <h4 class="fw-bold mb-3">Easy Payment Links</h4>
                        <p class="text-muted">
                            Integrated Paystack payment processing ensures your clients can pay 
                            securely with cards, bank transfers, and mobile money.
                        </p>
                    </div>
                </div>
            </div>
            
            <div class="col-md-4">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body text-center p-4">
                        <div class="feature-icon bg-warning bg-opacity-10 rounded-circle p-3 mb-3 mx-auto" style="width: 80px; height: 80px;">
                            <i class="bi bi-bell text-warning" style="font-size: 2rem;"></i>
                        </div>
                        <h4 class="fw-bold mb-3">Automatic Reminders</h4>
                        <p class="text-muted">
                            Never chase payments again. Automated email reminders keep your 
                            cash flow healthy and clients informed.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- How It Works Section -->
<section class="py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center mb-5">
                <h2 class="display-5 fw-bold mb-3">How SwiftBill NG Works</h2>
                <p class="lead text-muted">Get started in three simple steps</p>
            </div>
        </div>
        
        <div class="row g-4">
            <div class="col-md-4 text-center">
                <div class="step-number bg-primary text-white rounded-circle mx-auto mb-3 d-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                    <span class="fw-bold fs-4">1</span>
                </div>
                <h4 class="fw-bold mb-3">Create Invoice</h4>
                <p class="text-muted">
                    Add your client details, services, and amounts. Our system automatically 
                    generates professional invoices with payment links.
                </p>
            </div>
            
            <div class="col-md-4 text-center">
                <div class="step-number bg-primary text-white rounded-circle mx-auto mb-3 d-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                    <span class="fw-bold fs-4">2</span>
                </div>
                <h4 class="fw-bold mb-3">Share Link</h4>
                <p class="text-muted">
                    Send the invoice via email or share the payment link directly. 
                    Clients receive professional invoices with secure payment options.
                </p>
            </div>
            
            <div class="col-md-4 text-center">
                <div class="step-number bg-primary text-white rounded-circle mx-auto mb-3 d-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                    <span class="fw-bold fs-4">3</span>
                </div>
                <h4 class="fw-bold mb-3">Get Paid</h4>
                <p class="text-muted">
                    Receive instant notifications when payments are made. Money goes 
                    directly to your account with automatic receipt generation.
                </p>
            </div>
        </div>
    </div>
</section>

<!-- Stats Section -->
<section class="py-5">
    <div class="container">
        <div class="row text-center">
            <div class="col-md-3 mb-4">
                <div class="stat-item">
                    <h3 class="display-4 fw-bold text-primary mb-2">5K+</h3>
                    <p class="text-muted">Active Users</p>
                </div>
            </div>
            <div class="col-md-3 mb-4">
                <div class="stat-item">
                    <h3 class="display-4 fw-bold text-primary mb-2">₦2B+</h3>
                    <p class="text-muted">Processed</p>
                </div>
            </div>
            <div class="col-md-3 mb-4">
                <div class="stat-item">
                    <h3 class="display-4 fw-bold text-primary mb-2">50K+</h3>
                    <p class="text-muted">Invoices Sent</p>
                </div>
            </div>
            <div class="col-md-3 mb-4">
                <div class="stat-item">
                    <h3 class="display-4 fw-bold text-primary mb-2">99.9%</h3>
                    <p class="text-muted">Uptime</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-5 bg-primary text-white">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8">
                <h2 class="display-5 fw-bold mb-3">Ready to Get Paid Faster?</h2>
                <p class="lead mb-0">
                    Join thousands of Nigerian businesses already using SwiftBill NG to streamline their invoicing.
                </p>
            </div>
            <div class="col-lg-4 text-lg-end mt-4 mt-lg-0">
                <a href="register.php" class="btn btn-light btn-lg px-4">
                    <i class="bi bi-rocket-takeoff me-2"></i>Start Free Today
                </a>
            </div>
        </div>
    </div>
</section>

<?php include '../includes/footer.php'; ?>
