<?php
require_once '../includes/config.php';
require_once '../includes/auth.php';

$auth = getAuth();
$page_title = 'Login';

// Redirect if already logged in
if ($auth->isLoggedIn()) {
    header('Location: dashboard.php');
    exit();
}

// Generate CSRF token
$csrf_token = $auth->generateCSRFToken();
?>

<?php include '../includes/header.php'; ?>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-6 col-lg-4">
            <div class="card shadow-lg border-0">
                <div class="card-body p-5">
                    <div class="text-center mb-4">
                        <i class="bi bi-box-arrow-in-right text-primary" style="font-size: 3rem;"></i>
                        <h2 class="fw-bold mt-3">Welcome Back</h2>
                        <p class="text-muted">Sign in to your account</p>
                    </div>

                    <form id="loginForm" action="../actions/login_action.php" method="POST" x-data="loginForm()">
                        <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
                        
                        <div class="mb-3">
                            <label for="email" class="form-label">Email Address</label>
                            <input type="email" class="form-control" id="email" name="email" 
                                   x-model="form.email" required>
                            <div class="invalid-feedback" x-show="errors.email" x-text="errors.email"></div>
                        </div>

                        <div class="mb-3">
                            <label for="password" class="form-label">Password</label>
                            <div class="input-group">
                                <input :type="showPassword ? 'text' : 'password'" class="form-control" 
                                       id="password" name="password" x-model="form.password" required>
                                <button type="button" class="btn btn-outline-secondary" 
                                        @click="showPassword = !showPassword">
                                    <i :class="showPassword ? 'bi bi-eye-slash' : 'bi bi-eye'"></i>
                                </button>
                            </div>
                            <div class="invalid-feedback" x-show="errors.password" x-text="errors.password"></div>
                        </div>

                        <div class="mb-3 d-flex justify-content-between align-items-center">
                            <div class="form-check">
                                <input type="checkbox" class="form-check-input" id="remember" name="remember">
                                <label class="form-check-label" for="remember">
                                    Remember me
                                </label>
                            </div>
                            <a href="forgot-password.php" class="text-primary text-decoration-none">
                                Forgot password?
                            </a>
                        </div>

                        <button type="submit" class="btn btn-primary w-100 py-2" 
                                :disabled="loading" x-text="loading ? 'Signing In...' : 'Sign In'">
                        </button>
                    </form>

                    <div class="text-center mt-4">
                        <p class="text-muted">
                            Don't have an account? 
                            <a href="register.php" class="text-primary text-decoration-none fw-bold">Create Account</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function loginForm() {
    return {
        form: {
            email: '',
            password: ''
        },
        errors: {},
        loading: false,
        showPassword: false,
        
        validateForm() {
            this.errors = {};
            
            if (!this.form.email.trim()) {
                this.errors.email = 'Email is required';
            } else if (!/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(this.form.email)) {
                this.errors.email = 'Please enter a valid email address';
            }
            
            if (!this.form.password) {
                this.errors.password = 'Password is required';
            }
            
            return Object.keys(this.errors).length === 0;
        }
    }
}
</script>

<?php include '../includes/footer.php'; ?>
