<?php
require_once '../includes/config.php';
require_once '../includes/auth.php';

$auth = getAuth();
$page_title = 'Register';

// Redirect if already logged in
if ($auth->isLoggedIn()) {
    header('Location: dashboard.php');
    exit();
}

// Generate CSRF token
$csrf_token = $auth->generateCSRFToken();
?>

<?php include '../includes/header.php'; ?>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-6 col-lg-5">
            <div class="card shadow-lg border-0">
                <div class="card-body p-5">
                    <div class="text-center mb-4">
                        <i class="bi bi-person-plus-fill text-primary" style="font-size: 3rem;"></i>
                        <h2 class="fw-bold mt-3">Create Account</h2>
                        <p class="text-muted">Join thousands of Nigerian businesses</p>
                    </div>

                    <form id="registerForm" action="../actions/register_action.php" method="POST" x-data="registerForm()">
                        <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
                        
                        <div class="mb-3">
                            <label for="full_name" class="form-label">Full Name</label>
                            <input type="text" class="form-control" id="full_name" name="full_name" 
                                   x-model="form.full_name" required>
                            <div class="invalid-feedback" x-show="errors.full_name" x-text="errors.full_name"></div>
                        </div>

                        <div class="mb-3">
                            <label for="email" class="form-label">Email Address</label>
                            <input type="email" class="form-control" id="email" name="email" 
                                   x-model="form.email" required>
                            <div class="invalid-feedback" x-show="errors.email" x-text="errors.email"></div>
                        </div>

                        <div class="mb-3">
                            <label for="password" class="form-label">Password</label>
                            <div class="input-group">
                                <input :type="showPassword ? 'text' : 'password'" class="form-control" 
                                       id="password" name="password" x-model="form.password" required>
                                <button type="button" class="btn btn-outline-secondary" 
                                        @click="showPassword = !showPassword">
                                    <i :class="showPassword ? 'bi bi-eye-slash' : 'bi bi-eye'"></i>
                                </button>
                            </div>
                            <div class="form-text">
                                Password must be at least 8 characters with uppercase, lowercase, number, and special character.
                            </div>
                            <div class="invalid-feedback" x-show="errors.password" x-text="errors.password"></div>
                        </div>

                        <div class="mb-3">
                            <label for="confirm_password" class="form-label">Confirm Password</label>
                            <input type="password" class="form-control" id="confirm_password" 
                                   name="confirm_password" x-model="form.confirm_password" required>
                            <div class="invalid-feedback" x-show="errors.confirm_password" x-text="errors.confirm_password"></div>
                        </div>

                        <div class="mb-3 form-check">
                            <input type="checkbox" class="form-check-input" id="terms" name="terms" 
                                   x-model="form.terms" required>
                            <label class="form-check-label" for="terms">
                                I agree to the <a href="#" class="text-primary">Terms of Service</a> and 
                                <a href="#" class="text-primary">Privacy Policy</a>
                            </label>
                            <div class="invalid-feedback" x-show="errors.terms" x-text="errors.terms"></div>
                        </div>

                        <button type="submit" class="btn btn-primary w-100 py-2" 
                                :disabled="loading" x-text="loading ? 'Creating Account...' : 'Create Account'">
                        </button>
                    </form>

                    <div class="text-center mt-4">
                        <p class="text-muted">
                            Already have an account? 
                            <a href="login.php" class="text-primary text-decoration-none fw-bold">Sign In</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function registerForm() {
    return {
        form: {
            full_name: '',
            email: '',
            password: '',
            confirm_password: '',
            terms: false
        },
        errors: {},
        loading: false,
        showPassword: false,
        
        validateForm() {
            this.errors = {};
            
            if (!this.form.full_name.trim()) {
                this.errors.full_name = 'Full name is required';
            }
            
            if (!this.form.email.trim()) {
                this.errors.email = 'Email is required';
            } else if (!/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(this.form.email)) {
                this.errors.email = 'Please enter a valid email address';
            }
            
            if (!this.form.password) {
                this.errors.password = 'Password is required';
            } else if (this.form.password.length < 8) {
                this.errors.password = 'Password must be at least 8 characters';
            } else if (!/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[@$!%*?&])[A-Za-z\d@$!%*?&]/.test(this.form.password)) {
                this.errors.password = 'Password must contain uppercase, lowercase, number, and special character';
            }
            
            if (this.form.password !== this.form.confirm_password) {
                this.errors.confirm_password = 'Passwords do not match';
            }
            
            if (!this.form.terms) {
                this.errors.terms = 'You must agree to the terms and conditions';
            }
            
            return Object.keys(this.errors).length === 0;
        }
    }
}
</script>

<?php include '../includes/footer.php'; ?>
