# SwiftBill NG

A comprehensive invoicing and payment SaaS platform for Nigerian freelancers and SMEs.

## Features

- **Simple Invoicing**: Create professional invoices quickly
- **Easy Payment Links**: Integrated Paystack payment processing
- **Automatic Reminders**: Email notifications for payments
- **Mobile Responsive**: Works perfectly on all devices

## Tech Stack

- **Backend**: PHP 8+ (vanilla)
- **Database**: MySQL with MySQLi prepared statements
- **Frontend**: Bootstrap 5 + Alpine.js
- **Payment**: Paystack API integration
- **Email**: PHPMailer

## Setup Instructions

1. Create a MySQL database named `swiftbill_ng`
2. Import the database schema from `database/schema.sql`
3. Configure your database credentials in `includes/config.php`
4. Set up your Paystack API keys in the config file
5. Configure PHPMailer settings for email notifications

## Project Structure

```
swiftbill-ng/
├── public/
│   ├── index.php (Home page)
│   ├── about.php
│   ├── contact.php
│   ├── login.php
│   ├── register.php
│   └── dashboard.php
├── includes/
│   ├── config.php
│   ├── db.php
│   ├── auth.php
│   ├── header.php
│   └── footer.php
├── actions/
│   ├── register_action.php
│   ├── login_action.php
│   ├── create_invoice.php
│   └── paystack_webhook.php
├── assets/
│   ├── css/
│   ├── js/
│   └── images/
└── database/
    └── schema.sql
```

## Security Features

- Password hashing with bcrypt
- CSRF token protection
- XSS prevention
- Prepared statements for all database queries

## Getting Started

Visit the home page and click "Get Started" to create your account and start invoicing!
