<?php
require_once '../includes/config.php';
require_once '../includes/paystack.php';
require_once '../includes/db.php';
require_once '../includes/email.php';

// Set content type
header('Content-Type: application/json');

// Get the payload
$payload = file_get_contents('php://input');
$signature = $_SERVER['HTTP_X_PAYSTACK_SIGNATURE'] ?? '';

if (empty($payload) || empty($signature)) {
    http_response_code(400);
    echo json_encode(['error' => 'Missing payload or signature']);
    exit();
}

// Verify webhook signature
$paystack = new PaystackAPI();
if (!$paystack->verifyWebhookSignature($payload, $signature)) {
    http_response_code(401);
    echo json_encode(['error' => 'Invalid signature']);
    exit();
}

// Process the webhook event
$result = $paystack->processWebhookEvent($payload);

if ($result['success']) {
    http_response_code(200);
    echo json_encode(['message' => $result['message']]);
} else {
    http_response_code(400);
    echo json_encode(['error' => $result['message']]);
}

exit();
?>
