<?php
require_once '../includes/config.php';
require_once '../includes/auth.php';

$auth = getAuth();
$page_title = 'Contact Us';

// Generate CSRF token
$csrf_token = $auth->generateCSRFToken();
?>

<?php include '../includes/header.php'; ?>

<div class="container py-5">
    <div class="row">
        <div class="col-lg-8 mx-auto">
            <div class="text-center mb-5">
                <h1 class="display-4 fw-bold mb-3">Get in Touch</h1>
                <p class="lead text-muted">
                    Have questions? We'd love to hear from you. Send us a message and we'll respond as soon as possible.
                </p>
            </div>
            
            <div class="row g-4">
                <div class="col-lg-8">
                    <div class="card shadow-sm border-0">
                        <div class="card-body p-4">
                            <h3 class="fw-bold mb-4">Send us a Message</h3>
                            
                            <form id="contactForm" action="../actions/contact_action.php" method="POST" x-data="contactForm()">
                                <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
                                
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label for="name" class="form-label">Full Name</label>
                                        <input type="text" class="form-control" id="name" name="name" 
                                               x-model="form.name" required>
                                        <div class="invalid-feedback" x-show="errors.name" x-text="errors.name"></div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <label for="email" class="form-label">Email Address</label>
                                        <input type="email" class="form-control" id="email" name="email" 
                                               x-model="form.email" required>
                                        <div class="invalid-feedback" x-show="errors.email" x-text="errors.email"></div>
                                    </div>
                                    
                                    <div class="col-12">
                                        <label for="subject" class="form-label">Subject</label>
                                        <select class="form-select" id="subject" name="subject" x-model="form.subject" required>
                                            <option value="">Choose a subject</option>
                                            <option value="general">General Inquiry</option>
                                            <option value="support">Technical Support</option>
                                            <option value="billing">Billing Question</option>
                                            <option value="feature">Feature Request</option>
                                            <option value="partnership">Partnership</option>
                                            <option value="other">Other</option>
                                        </select>
                                        <div class="invalid-feedback" x-show="errors.subject" x-text="errors.subject"></div>
                                    </div>
                                    
                                    <div class="col-12">
                                        <label for="message" class="form-label">Message</label>
                                        <textarea class="form-control" id="message" name="message" rows="5" 
                                                  x-model="form.message" placeholder="Tell us how we can help you..." required></textarea>
                                        <div class="invalid-feedback" x-show="errors.message" x-text="errors.message"></div>
                                    </div>
                                    
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-primary btn-lg px-4" 
                                                :disabled="loading" x-text="loading ? 'Sending...' : 'Send Message'">
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-4">
                    <div class="contact-info">
                        <div class="card border-0 bg-light mb-4">
                            <div class="card-body p-4">
                                <h5 class="fw-bold mb-3">
                                    <i class="bi bi-envelope text-primary me-2"></i>Email Us
                                </h5>
                                <p class="text-muted mb-2">For general inquiries:</p>
                                <a href="mailto:support@swiftbillng.com" class="text-primary text-decoration-none">
                                    support@swiftbillng.com
                                </a>
                                
                                <p class="text-muted mb-2 mt-3">For business partnerships:</p>
                                <a href="mailto:partnerships@swiftbillng.com" class="text-primary text-decoration-none">
                                    partnerships@swiftbillng.com
                                </a>
                            </div>
                        </div>
                        
                        <div class="card border-0 bg-light mb-4">
                            <div class="card-body p-4">
                                <h5 class="fw-bold mb-3">
                                    <i class="bi bi-telephone text-primary me-2"></i>Call Us
                                </h5>
                                <p class="text-muted mb-2">Support Hotline:</p>
                                <a href="tel:+2348001234567" class="text-primary text-decoration-none fw-bold">
                                    +234 800 SWIFT (79438)
                                </a>
                                <p class="text-muted small mt-2">
                                    Monday - Friday: 8AM - 6PM WAT<br>
                                    Saturday: 9AM - 2PM WAT
                                </p>
                            </div>
                        </div>
                        
                        <div class="card border-0 bg-light">
                            <div class="card-body p-4">
                                <h5 class="fw-bold mb-3">
                                    <i class="bi bi-geo-alt text-primary me-2"></i>Visit Us
                                </h5>
                                <address class="text-muted mb-0">
                                    SwiftBill NG<br>
                                    123 Innovation Drive<br>
                                    Victoria Island<br>
                                    Lagos, Nigeria
                                </address>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- FAQ Section -->
<section class="py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="text-center mb-5">
                    <h2 class="display-5 fw-bold mb-3">Frequently Asked Questions</h2>
                    <p class="lead text-muted">Quick answers to common questions</p>
                </div>
                
                <div class="accordion" id="faqAccordion">
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faq1">
                                How do I get started with SwiftBill NG?
                            </button>
                        </h2>
                        <div id="faq1" class="accordion-collapse collapse show" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                Simply click "Get Started" to create your free account. You can start creating and sending invoices immediately after email verification.
                            </div>
                        </div>
                    </div>
                    
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq2">
                                What payment methods do you support?
                            </button>
                        </h2>
                        <div id="faq2" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                We support all major payment methods through Paystack including debit/credit cards, bank transfers, USSD, and mobile money.
                            </div>
                        </div>
                    </div>
                    
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq3">
                                Are there any setup fees?
                            </button>
                        </h2>
                        <div id="faq3" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                No setup fees! SwiftBill NG is free to use. We only charge a small transaction fee when you receive payments through our platform.
                            </div>
                        </div>
                    </div>
                    
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq4">
                                How secure is my data?
                            </button>
                        </h2>
                        <div id="faq4" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                Your data is protected with bank-level security including SSL encryption, secure servers, and regular security audits. We never store your payment information.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
function contactForm() {
    return {
        form: {
            name: '',
            email: '',
            subject: '',
            message: ''
        },
        errors: {},
        loading: false,
        
        validateForm() {
            this.errors = {};
            
            if (!this.form.name.trim()) {
                this.errors.name = 'Name is required';
            }
            
            if (!this.form.email.trim()) {
                this.errors.email = 'Email is required';
            } else if (!/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(this.form.email)) {
                this.errors.email = 'Please enter a valid email address';
            }
            
            if (!this.form.subject) {
                this.errors.subject = 'Please select a subject';
            }
            
            if (!this.form.message.trim()) {
                this.errors.message = 'Message is required';
            } else if (this.form.message.trim().length < 10) {
                this.errors.message = 'Message must be at least 10 characters';
            }
            
            return Object.keys(this.errors).length === 0;
        }
    }
}
</script>

<?php include '../includes/footer.php'; ?>
