<?php
// webhook.php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/db.php'; // if you need DB access

// 1. Read raw request body
$input = @file_get_contents("php://input");
$signature = $_SERVER['HTTP_X_PAYSTACK_SIGNATURE'] ?? '';

// 2. Verify signature using PAYSTACK_WEBHOOK_SECRET
if ($signature !== hash_hmac('sha512', $input, PAYSTACK_WEBHOOK_SECRET)) {
    http_response_code(401);
    exit('Invalid signature');
}

// 3. Parse the event data
$data = json_decode($input, true);
if (!$data || !isset($data['event'])) {
    http_response_code(400);
    exit('Invalid payload');
}

// 4. Handle events
switch ($data['event']) {
    case 'charge.success':
        $payment = $data['data'];

        // Example: Update invoice as paid
        $invoiceId = $payment['metadata']['invoice_id'] ?? null;
        $amount = $payment['amount'] / 100; // convert from kobo to naira

        if ($invoiceId) {
            $stmt = $db->prepare("UPDATE invoices SET status = 'paid', paid_amount = ? WHERE id = ?");
            $stmt->bind_param("di", $amount, $invoiceId);
            $stmt->execute();

            // Optionally log the payment
            $log = $db->prepare("INSERT INTO payment_logs (invoice_id, raw_data) VALUES (?, ?)");
            $json = json_encode($payment);
            $log->bind_param("is", $invoiceId, $json);
            $log->execute();
        }

        http_response_code(200);
        echo "Invoice updated";
        break;

    default:
        http_response_code(200);
        echo "Event ignored";
        break;
}
